/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id:  $:

  Description:
    Implementation of the cifX API library class

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2006-06-28  initial version

**************************************************************************************/

#include "StdAfx.h"
#include "cifXAPIlib.h"
#include "cifXErrors.h"

///////////////////////////////////////////////////////////////////////////////////////////
/// \file cifXAPIlib.cpp
///  Implementation of the cifX API library class
///////////////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
/// Constructuor
/////////////////////////////////////////////////////////////////////////////
CCifXAPIlib::CCifXAPIlib()
:m_hDll(NULL)
,m_hDriver(NULL)
,m_fSelected(false)
,m_fRemoteAPI(false)
{
}

/////////////////////////////////////////////////////////////////////////////
/// Destructor
/////////////////////////////////////////////////////////////////////////////
CCifXAPIlib::~CCifXAPIlib(void)
{
}

DRIVER_INFORMATION CCifXAPIlib::DriverGetInformation   ( void)
{
  DRIVER_INFORMATION tDriverInfo = {0};
  if (Valid())
  {
    xDriverGetInformation(m_hDriver, sizeof(tDriverInfo), &tDriverInfo);
  }
  return tDriverInfo;
}

int32_t CCifXAPIlib::DriverEnumBoards       ( uint32_t ulBoard, uint32_t ulSize, void* pvBoardInfo)
{
  return xDriverEnumBoards(m_hDriver, ulBoard, ulSize, pvBoardInfo);
}

int32_t CCifXAPIlib::DriverEnumChannels     ( uint32_t ulBoard, uint32_t ulChannel, uint32_t ulSize, void* pvChannelInfo)
{
  return xDriverEnumChannels(m_hDriver, ulBoard, ulChannel, ulSize, pvChannelInfo);
}

int32_t CCifXAPIlib::DriverMemoryPointer    ( uint32_t ulBoard, uint32_t ulCmd,void* pvMemoryInfo)
{
  return xDriverMemoryPointer(m_hDriver, ulBoard, ulCmd, pvMemoryInfo);
}

int32_t CCifXAPIlib::DriverRestartDevice    ( char* szBoardName, void* pvData)
{
  return xDriverRestartDevice    (m_hDriver,szBoardName,pvData);
}

int32_t CCifXAPIlib::SysdeviceOpen ( char*   szBoard, CIFXHANDLE* phSysdevice)
{
  return xSysdeviceOpen(m_hDriver, szBoard, phSysdevice);
}

int32_t CCifXAPIlib::ChannelOpen (char* szBoard, uint32_t ulChannel, CIFXHANDLE* phChannel)
{
  return xChannelOpen(m_hDriver, szBoard, ulChannel, phChannel);
}

  /*****************************************************************************/
/*! This Function loads the cifX RTX Driver library and fills 
 *  the cifX API function table
 *   \param  ptVTable Pointer to cifX API function table
 *   \return HANDLE to driver library                                        */
/*****************************************************************************/
int32_t CCifXAPIlib::DriverOpen ( char* szFileName )
{
  m_lError = CIFX_NO_ERROR;

  /* Load the RTX driver DLL      */
  if ( ( m_hDll = LoadLibrary( szFileName)) == NULL) 
  {
    /* Error loading the DLL */
    m_lError = CIFX_DRV_DRIVER_NOT_LOADED;

  /* Load function pointer        */
  } else if (  
               /* Global driver functions */ 
               ((xDriverOpen               = ((X_DRIVER_OPEN)                     GetProcAddress( m_hDll, "xDriverOpen")))                == NULL)  ||
               ((xDriverClose              = ((X_DRIVER_CLOSE)                    GetProcAddress( m_hDll, "xDriverClose")))               == NULL)  ||
               ((xDriverGetInformation     = ((X_DRIVER_GET_INFORMATION)          GetProcAddress( m_hDll, "xDriverGetInformation")))      == NULL)  ||
               ((xDriverGetErrorDescription= ((X_DRIVER_GET_ERROR_DESCRIPTION)    GetProcAddress( m_hDll, "xDriverGetErrorDescription"))) == NULL)  ||
               ((xDriverEnumBoards         = ((X_DRIVER_ENUM_BOARDS)              GetProcAddress( m_hDll, "xDriverEnumBoards")))          == NULL)  ||
               ((xDriverEnumChannels       = ((X_DRIVER_ENUM_CHANNELS)            GetProcAddress( m_hDll, "xDriverEnumChannels")))        == NULL)  ||
               ((xDriverMemoryPointer      = ((X_DRIVER_MEMORY_POINTER)           GetProcAddress( m_hDll, "xDriverMemoryPointer")))       == NULL)  ||
               ((xDriverRestartDevice      = ((X_DRIVER_RESTART_DEVICE)           GetProcAddress( m_hDll, "xDriverRestartDevice")))       == NULL)  ||

               /* System device depending functions */               
               ((xSysdeviceOpen              = ((X_SYSDEVICE_OPEN)                GetProcAddress( m_hDll, "xSysdeviceOpen")))              == NULL)  ||
               ((xSysdeviceClose             = ((X_SYSDEVICE_CLOSE)               GetProcAddress( m_hDll, "xSysdeviceClose")))             == NULL)  ||
               ((xSysdeviceGetMBXState       = ((X_SYSDEVICE_GET_MBX_STATE)       GetProcAddress( m_hDll, "xSysdeviceGetMBXState")))       == NULL)  ||
               ((xSysdevicePutPacket         = ((X_SYSDEVICE_PUT_PACKET)          GetProcAddress( m_hDll, "xSysdevicePutPacket")))         == NULL)  ||
               ((xSysdeviceGetPacket         = ((X_SYSDEVICE_GET_PACKET)          GetProcAddress( m_hDll, "xSysdeviceGetPacket")))         == NULL)  ||
               ((xSysdeviceInfo              = ((X_SYSDEVICE_INFO)                GetProcAddress( m_hDll, "xSysdeviceInfo")))              == NULL)  ||
               ((xSysdeviceFindFirstFile     = ((X_SYSDEVICE_FIND_FIRST_FILE)     GetProcAddress( m_hDll, "xSysdeviceFindFirstFile")))     == NULL)  ||
               ((xSysdeviceFindNextFile      = ((X_SYSDEVICE_FIND_NEXT_FILE)      GetProcAddress( m_hDll, "xSysdeviceFindNextFile")))      == NULL)  ||
               ((xSysdeviceDownload          = ((X_SYSDEVICE_DOWNLOAD)            GetProcAddress( m_hDll, "xSysdeviceDownload")))          == NULL)  ||
               ((xSysdeviceUpload            = ((X_SYSDEVICE_UPLOAD)              GetProcAddress( m_hDll, "xSysdeviceUpload")))            == NULL)  ||
               ((xSysdeviceReset             = ((X_SYSDEVICE_RESET)               GetProcAddress( m_hDll, "xSysdeviceReset")))             == NULL)  ||

               /* Channel depending functions */
               ((xChannelOpen                = ((X_CHANNEL_OPEN)                  GetProcAddress( m_hDll, "xChannelOpen")))                == NULL)  ||
               ((xChannelClose               = ((X_CHANNEL_CLOSE)                 GetProcAddress( m_hDll, "xChannelClose")))               == NULL)  ||
               ((xChannelPutPacket           = ((X_CHANNEL_PUT_PACKET)            GetProcAddress( m_hDll, "xChannelPutPacket")))           == NULL)  ||
               ((xChannelGetPacket           = ((X_CHANNEL_GET_PACKET)            GetProcAddress( m_hDll, "xChannelGetPacket")))           == NULL)  ||
               ((xChannelGetMBXState         = ((X_CHANNEL_GET_MBX_STATE)         GetProcAddress( m_hDll, "xChannelGetMBXState")))         == NULL)  ||
               ((xChannelIORead              = ((X_CHANNEL_IOREAD)                GetProcAddress( m_hDll, "xChannelIORead")))              == NULL)  ||
               ((xChannelIOWrite             = ((X_CHANNEL_IOWRITE)               GetProcAddress( m_hDll, "xChannelIOWrite")))             == NULL)  ||
               ((xChannelFindFirstFile       = ((X_CHANNEL_FIND_FIRST_FILE)       GetProcAddress( m_hDll, "xChannelFindFirstFile")))       == NULL)  ||
               ((xChannelFindNextFile        = ((X_CHANNEL_FIND_NEXT_FILE)        GetProcAddress( m_hDll, "xChannelFindNextFile")))        == NULL)  ||
               ((xChannelDownload            = ((X_CHANNEL_DOWNLOAD)              GetProcAddress( m_hDll, "xChannelDownload")))            == NULL)  ||
               ((xChannelUpload              = ((X_CHANNEL_UPLOAD)                GetProcAddress( m_hDll, "xChannelUpload")))              == NULL)  ||
               ((xChannelGetSendPacket       = ((X_CHANNEL_GET_SEND_PACKET)       GetProcAddress( m_hDll, "xChannelGetSendPacket")))       == NULL)  ||
               ((xChannelConfigLock          = ((X_CHANNEL_CONFIG_LOCK)           GetProcAddress( m_hDll, "xChannelConfigLock")))          == NULL)  ||
               ((xChannelReset               = ((X_CHANNEL_RESET)                 GetProcAddress( m_hDll, "xChannelReset")))               == NULL)  ||
               ((xChannelInfo                = ((X_CHANNEL_INFO)                  GetProcAddress( m_hDll, "xChannelInfo")))                == NULL)  ||
               ((xChannelWatchdog            = ((X_CHANNEL_WATCHDOG)              GetProcAddress( m_hDll, "xChannelWatchdog")))            == NULL)  ||
               ((xChannelHostState           = ((X_CHANNEL_HOST_STATE)            GetProcAddress( m_hDll, "xChannelHostState")))           == NULL)  ||
               ((xChannelBusState            = ((X_CHANNEL_BUS_STATE)             GetProcAddress( m_hDll, "xChannelBusState")))            == NULL)  ||
               ((xChannelDMAState            = ((X_CHANNEL_DMA_STATE)             GetProcAddress( m_hDll, "xChannelDMAState")))            == NULL)  ||
               ((xChannelIOInfo              = ((X_CHANNEL_IOINFO)                GetProcAddress( m_hDll, "xChannelIOInfo")))              == NULL)  ||
               ((xChannelIOReadSendData      = ((X_CHANNEL_IOREAD_SEND_DATA)      GetProcAddress( m_hDll, "xChannelIOReadSendData")))      == NULL)  ||
               ((xChannelControlBlock        = ((X_CHANNEL_CONTROL_BLOCK)         GetProcAddress( m_hDll, "xChannelControlBlock")))        == NULL)  ||
               ((xChannelCommonStatusBlock   = ((X_CHANNEL_COMMON_STATUS_BLOCK)   GetProcAddress( m_hDll, "xChannelCommonStatusBlock")))   == NULL)  ||
               ((xChannelExtendedStatusBlock = ((X_CHANNEL_EXTENDED_STATUS_BLOCK) GetProcAddress( m_hDll, "xChannelExtendedStatusBlock"))) == NULL)  ||
               /*((xChannelUserBlock           = ((X_CHANNEL_USER_BLOCK)            GetProcAddress( m_hDll, "xChannelUserBlock")))           == NULL)  ||*/
               ((xChannelPLCMemoryPtr        = ((X_CHANNEL_PLC_MEMORYPTR)         GetProcAddress( m_hDll, "xChannelPLCMemoryPtr")))        == NULL)  ||
               ((xChannelPLCIsReadReady      = ((X_CHANNEL_PLC_IS_READ_READY)     GetProcAddress( m_hDll, "xChannelPLCIsReadReady")))      == NULL)  ||
               ((xChannelPLCIsWriteReady     = ((X_CHANNEL_PLC_IS_WRITE_READY)    GetProcAddress( m_hDll, "xChannelPLCIsWriteReady")))     == NULL)  ||
               ((xChannelPLCActivateWrite    = ((X_CHANNEL_PLC_ACTIVATE_WRITE)    GetProcAddress( m_hDll, "xChannelPLCActivateWrite")))    == NULL)  ||
               ((xChannelPLCActivateRead     = ((X_CHANNEL_PLC_ACTIVATE_READ)     GetProcAddress( m_hDll, "xChannelPLCActivateRead")))     == NULL)  )
  {
    /* Error loading functions from the RTX driver DLL */
    FreeLibrary(m_hDll);
    m_lError = CIFX_DRV_DRIVER_NOT_LOADED;

  } else
  {
    nxConEnumerate          = ((NX_CON_ENUMERATE)            GetProcAddress( m_hDll, "nxConEnumerate"));
    nxConCreateConfigDialog = ((NX_CON_CREATE_CONFIG_DIALOG) GetProcAddress( m_hDll, "nxConCreateConfigDialog"));
    nxConCloseConfigDialog  = ((NX_CON_CLOSE_CONFIG_DIALOG)  GetProcAddress( m_hDll, "nxConCloseConfigDialog"));

    m_lError = xDriverOpen(&m_hDriver);
  }

  return m_lError;
}

/*****************************************************************************/
/*! This Function closes the cifX RTX Driver library
 *   \return HANDLE to driver library                                        */
/*****************************************************************************/
int32_t CCifXAPIlib::DriverClose(void)
{
  int32_t lRet = CIFX_NO_ERROR;
  
  if (NULL != m_hDll)
  {
    lRet = xDriverClose(m_hDriver);
    m_hDriver = NULL;
    FreeLibrary(m_hDll);
    m_hDll = NULL;
  } else
  {
    lRet = CIFX_DRV_DRIVER_NOT_LOADED;
  }
  
  return lRet;
}

bool CCifXAPIlib::Valid ( void)
{
  if (m_hDll)
    return true;
  else
    return false;
}

void CCifXAPIlib::SetSelected ( bool fFlag)
{
  m_fSelected = fFlag;
}

bool CCifXAPIlib::GetSelected ( void)
{
  return m_fSelected;
}

void CCifXAPIlib::SetRemoteAPI ( void)
{
  m_fRemoteAPI = true;
}

bool CCifXAPIlib::IsRemoteAPI ( void)
{
  return m_fRemoteAPI;
}
